<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateImageablesTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('imageables')) {
            Schema::create('imageables', function (Blueprint $table) {
                $table->increments('id');

                $table->unsignedInteger('image_id')->index();
                $table->unsignedInteger('imageable_id')->index();
                $table->string('imageable_type')->index();

                $table->foreign('image_id')
                    ->references('id')
                    ->on('images')
                    ->onUpdate('cascade')
                    ->onDelete('cascade');

                $table->index(['image_id', 'imageable_id', 'imageable_type'], 'images_iit_index');
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('imageables');
    }
}
