<?php

use Bongo\Image\Models\Image;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

class AddOrientationColumnToImagesTable extends Migration
{
    public function up()
    {
        // If the column does not exist then add it
        if (! Schema::hasColumn('images', 'orientation')) {
            Schema::table('images', function (Blueprint $table) {
                $table->string('orientation')
                    ->default(Image::LANDSCAPE)
                    ->after('height');
            });

            // If this is not an install because we already have images then update their dimensions
            $images = Image::all();
            if ($images && count($images) > 1) {
                Artisan::call('image:update_dimensions');
            }
        }
    }

    public function down()
    {
        Schema::table('images', function (Blueprint $table) {
            $table->dropColumn('orientation');
        });
    }
}
