<?php

use Bongo\Image\Http\Controllers\Backend\ImageController;
use Illuminate\Support\Facades\Route;

Route::group(['as' => 'image.', 'prefix' => 'images'], function () {

    Route::get('/', [ImageController::class, 'index'])
        ->name('index');

    Route::post('store', [ImageController::class, 'store'])
        ->name('store');

    Route::post('copy', [ImageController::class, 'copy'])
        ->name('copy');

    // Image/{image}/
    Route::prefix('{image}')
        ->group(function () {
            Route::post('update', [ImageController::class, 'update'])
                ->name('update');

            Route::delete('delete', [ImageController::class, 'destroy'])
                ->name('destroy');
        });
});
