<?php

namespace Bongo\Image\Commands;

use Bongo\Image\Models\Image;
use Exception;
use Illuminate\Console\Command;

class UpdateDimensionsCommand extends Command
{
    /** @var string */
    protected $signature = 'image:update_dimensions';

    /** @var string */
    protected $description = 'Loop through all the images that do not have dimensions and update them';

    public function handle()
    {
        $images = Image::whereNull('width')->orWhereNull('height')->get();

        // Loop through all images
        foreach ($images as $image) {
            console_print("- Checking image dimensions: {$image->id}");

            try {
                // Get the dimensions from the file
                [$width, $height] = getimagesize($image->getFileSrc());

                // Set the width & height
                $image->width = $width;
                $image->height = $height;

                // Set the orientation
                $image->orientation = ($image->width > $image->height)
                    ? Image::LANDSCAPE
                    : Image::PORTRAIT;

                // Save the image
                $image->save();
                console_print("-- Updating image dimensions");

            } catch (Exception $e) {
                console_print($e->getMessage());
                continue;
            }
        }
    }
}
