<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUUIDColumnToImagesTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('images', 'uuid')) {
            Schema::table('images', function (Blueprint $table) {
                $table->uuid('uuid')->index()->after('id');
            });
        }
    }

    public function down()
    {
        Schema::table('images', function (Blueprint $table) {
            $table->dropColumn('uuid');
        });
    }
}
