<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class MoveSortOrderColumnToImageablesTable extends Migration
{
    public function up()
    {
        if (Schema::hasColumn('images', 'sort_order')) {
            Schema::table('images', function (Blueprint $table) {
                $table->dropColumn('sort_order');
            });
        }

        // If the column does not exist then add it
        if (! Schema::hasColumn('imageables', 'sort_order')) {
            Schema::table('imageables', function (Blueprint $table) {
                $table->integer('sort_order')->nullable();
            });
        }
    }

    public function down()
    {
        Schema::table('imageables', function (Blueprint $table) {
            $table->dropColumn('sort_order');
        });

        if (! Schema::hasColumn('images', 'sort_order')) {
            Schema::table('images', function (Blueprint $table) {
                $table->integer('sort_order')->nullable()->after('type');
            });
        }
    }
}
