<?php

namespace Bongo\Import\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Storage;

class ResetCommand extends Command
{
    /** @var string */
    protected $signature = 'import:reset';

    /** @var string */
    protected $description = 'Resets database/downloads before an import.';

    public function handle()
    {
        Schema::disableForeignKeyConstraints();
        if (Schema::hasTable('pages')) {
            DB::table('pages')->truncate();
        }
        if (Schema::hasTable('posts')) {
            DB::table('posts')->truncate();
        }
        if (Schema::hasTable('reviews')) {
            DB::table('reviews')->truncate();
        }
        if (Schema::hasTable('images')) {
            DB::table('images')->truncate();
        }
        if (Schema::hasTable('imageables')) {
            DB::table('imageables')->truncate();
        }
        Schema::enableForeignKeyConstraints();

        if (Storage::exists('/public/pages')) {
            Storage::deleteDirectory('/public/pages');
        }
        if (Storage::exists('/public/posts')) {
            Storage::deleteDirectory('/public/posts');
        }
        if (Storage::exists('/public/cache')) {
            Storage::deleteDirectory('/public/cache');
        }

        console_print('Database/downloads have been reset :)');
    }
}
