<?php

namespace Bongo\Import\Helpers;

use Bongo\Framework\Helpers\File;
use Bongo\Image\Models\Image;
use Illuminate\Support\Facades\Storage;

class ImageHelper
{
    public static function store($model, string $imageUrl, string $directory, string $type, int $key = 1): Image
    {
        // If this is a cover image then delete the other imagesZ
        if ($type === Image::COVER_IMAGE && $model->hasImages()) {
            $model->images()->where('type', Image::COVER_IMAGE)->delete();
        }

        // Get the file info
        $ext = pathinfo($imageUrl, PATHINFO_EXTENSION);
        $name = rtrim(pathinfo($imageUrl, PATHINFO_FILENAME), $ext);
        $fileName = File::generateName($name, $ext);

        [$width, $height] = getimagesize($imageUrl);

        // Get the file contents and save
        $filePath = "/public/{$directory}/{$model->id}/";
        $file = file_get_contents($imageUrl);
        Storage::put("{$filePath}/{$fileName}", $file);

        // Insert the file details into the database
        $dbImage = new Image();
        $dbImage->name = $fileName;
        $dbImage->title = $model->name ?? null;
        $dbImage->path = $filePath;
        $dbImage->ext = $ext;
        $dbImage->type = $type;
        $dbImage->created_by = user() ? user()->id : null;
        $dbImage->updated_by = user() ? user()->id : null;

        // Set the dimensions
        $dbImage->width = $width;
        $dbImage->height = $height;
        $dbImage->orientation = ($width > $height) ? Image::LANDSCAPE : Image::PORTRAIT;

        // Attach the image relationship to the product
        $model->images()->save($dbImage, ['sort_order' => $key]);

        return $dbImage;
    }

    public static function remoteFileExists(string $fileUrl): bool
    {
        // Initialize cURL
        $ch = curl_init($fileUrl);
        curl_setopt($ch, CURLOPT_NOBODY, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); // Skip SSL Verification
        curl_exec($ch);
        $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Check the response code
        return $responseCode === 200;
    }
}
