<?php

namespace Bongo\Import\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Chunk extends Model
{
    /** @var string */
    protected $connection = 'import';

    /** @var string */
    protected $table = 'chunks';

    public function page(): BelongsTo
    {
        return $this->belongsTo(Page::class);
    }

    public function texts(): HasMany
    {
        return $this->hasMany(Text::class)->orderBy('text_index');
    }
}
