<?php

namespace Bongo\Import\Services;

use Bongo\Framework\Helpers\Html;
use Illuminate\Support\Str;

abstract class BongoImport
{
    protected function cleanHtml(string $html): string
    {
        $html = str_replace(["<br>", "<br\>", "<br /\>", "<br/>", "<br />"], '', $html);
        $html = Html::parse($html);
        $html = Html::removeStyles($html);
        $html = Html::removeClasses($html);
        $html = Html::removeEmptyTags($html);
        $html = Html::wrapIcons($html);
        $html = Html::wrapShortCodes($html);
        $html = Html::removeTags($html, ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'p', 'b', 'i', 'ul', 'li', 'a', 'img']);
        $html = str_replace('<p><p>', '<p>', $html);
        $html = str_replace('</p></p>', '</p>', $html);

        return $html;
    }

    protected function updateLinks(string $html, string $siteUrl): string
    {
        $siteUrl = str_replace(['https://', 'http://', 'www.'], '', $siteUrl);

        return preg_replace_callback('/href=[\'"](.*?)[\'"]/i', function ($matches) use ($siteUrl) {
            $url = $matches[1] ?? $matches[0];

            // Remove href
            if (Str::contains($url, 'href=')) {
                $url = str_replace('href=', '', $url);
                $url = ltrim($url, '"');
                $url = rtrim($url, '"');
            }

            // Remove the domain
            if (Str::contains($url, $siteUrl)) {
                $url = str_replace(['https://', 'http://', 'www.'], '', $url);
                $url = str_replace($siteUrl, '', $url);
            }

            // Update page links
            if (Str::contains($url, '?p=')) {
                $url = str_replace('?p=', '', $url);
                $url = str_replace('.', '-', $url);
                $url = '/'.Str::slug($url);
            }

            // Update review links
            if (Str::contains($url, '?review=reviews/')) {
                $url = str_replace('?review=reviews/', '/reviews', $url);
            }

            // Update block links
            if (Str::contains($url, '?blog=blogs/archive/')) {
                $url = str_replace('?blog=blogs/archive/', '', $url);
                $url = rtrim($url, '.aspx');

                // Check if the url format is /YYYY/MM/DD/{name}
                if (preg_match_all('/^(\d{4})\/(\d{2})\/(\d{2})(.*)?$/', $url, $matches)) {

                    // If it is then get the last segment
                    if (isset($matches[4])) {
                        $slug = is_array($matches[4]) ? $matches[4][0] : $matches[4];
                        $slug = str_replace('/', '', $slug);
                        $slug = str_replace('.', '-', $slug);
                        $url = '/posts/'.Str::slug($slug);
                    }
                }
            }

            return 'href="'.$url.'"';

        }, $html);
    }

    protected function updateImageSrc(string $imageSrc, string $siteUrl): string
    {
        $siteUrl = str_replace(['https://', 'http://', 'www.'], '', $siteUrl);

        // Remove the domain
        if (Str::contains($imageSrc, $siteUrl)) {
            $imageSrc = str_replace(['https://', 'http://', 'www.'], '', $imageSrc);
            $imageSrc = str_replace($siteUrl, '', $imageSrc);
        }

        // Remove the last slash and make sure we have a forward slash
        $imageSrc = ltrim($imageSrc, '/');
        $imageSrc = rtrim($imageSrc, '/');

        // Encode spaces
        $imageSrc = str_replace(' ', '%20', $imageSrc);

        return "/$imageSrc";
    }
}
