<?php

namespace Bongo\Import\Services;

use Bongo\Import\Models\Review as BongoReview;
use Bongo\Review\Models\Review;

class ImportReviewFromBongo
{
    public function __construct(BongoReview $bongoReview)
    {
        $review = Review::firstOrNew([
            'title' => $bongoReview->title,
            'name' => $bongoReview->contactname,
        ]);
        $review->date = $bongoReview->modwhen ?? null;
        $review->title = $bongoReview->title;
        $review->content = $bongoReview->review;
        $review->email = $bongoReview->contactemail;
        $review->status = Review::ACTIVE;
        $review->rating = round($bongoReview->rank / 2);
        $review->save();
    }
}
