<?php

namespace Bongo\Install\Helpers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class EnvironmentManager
{
    private string $envPath;

    private string $envExamplePath;

    public function __construct()
    {
        $this->envPath = base_path('.env');
        $this->envExamplePath = base_path('.env.example');
    }

    public function get(): string
    {
        if (! file_exists($this->envPath)) {
            if (file_exists($this->envExamplePath)) {
                copy($this->envExamplePath, $this->envPath);
            } else {
                touch($this->envPath);
            }
        }

        return file_get_contents($this->envPath);
    }

    public function getAsArray(): array
    {
        $envArray = [];
        $envContent = str_replace('"', "'", $this->get());
        $envContent = explode("\n", $envContent);

        if (! empty($envContent)) {
            foreach ($envContent as $item) {
                if (! empty($item)) {
                    $segments = explode('=', $item);
                    if (isset($segments[0]) && isset($segments[1])) {
                        $value = preg_replace('/\s\s+/', ' ', $segments[1]);
                        $value = ltrim($value, "'");
                        $value = rtrim($value, "'");
                        $envArray[$segments[0]] = trim($value);
                    }
                }
            }
        }

        return $envArray;
    }

    public function set(Request $request): mixed
    {
        // App settings
        $envFileData = "APP_NAME=Bongo\n";
        $envFileData .= "APP_ENV={$request->environment}\n";
        $envFileData .= 'APP_KEY='.'base64:'.base64_encode(Str::random(32))."\n";
        $envFileData .= "APP_URL={$request->app_url}\n\n";

        // Debugging
        $envFileData .= "APP_DEBUG={$request->app_debug}\n";
        $envFileData .= "DEBUGBAR_ENABLED=false\n";

        // Performance
        $envFileData .= "CACHE_DRIVER=database\n";
        $envFileData .= "SESSION_DRIVER=database\n\n";

        // Database settings
        $envFileData .= "DB_HOST='{$request->database_host}'\n";
        $envFileData .= "DB_ENGINE=InnoDB\n";
        $envFileData .= "DB_DATABASE='{$request->database_name}'\n";
        $envFileData .= "DB_USERNAME='{$request->database_username}'\n";
        $envFileData .= "DB_PASSWORD='{$request->database_password}'\n\n";

        // Mail settings
        $envFileData .= "MAIL_HOST='{$request->mail_host}'\n";
        $envFileData .= "MAIL_PORT={$request->mail_port}\n";
        $envFileData .= "MAIL_USERNAME='{$request->mail_username}'\n";
        $envFileData .= "MAIL_PASSWORD='{$request->mail_password}'\n";
        $envFileData .= "MAIL_FROM_ADDRESS='{$request->mail_from_address}'\n";
        $envFileData .= "MAIL_FROM_NAME='{$request->mail_from_name}'\n\n";

        // Minification
        $envFileData .= "MINIFY_HTML_ENABLED=true\n";

        try {
            file_put_contents($this->envPath, $envFileData);

            return trans('install::frontend.environment.success');

        } catch (Exception $e) {
            Log::error($e->getMessage());

            return trans('install::frontend.environment.errors');
        }
    }

    public function prepend($value): mixed
    {
        $envFile = $this->get();
        $envFile .= "\n".$value;

        try {
            file_put_contents($this->envPath, $envFile);

            return trans('install::frontend.environment.success');

        } catch (Exception $e) {
            Log::error($e->getMessage());

            return trans('install::frontend.environment.errors');
        }
    }
}
