<?php

namespace Bongo\Install\Helpers;

class PermissionsChecker
{
    protected array $results = [];

    public function __construct()
    {
        $this->results['permissions'] = [];
        $this->results['errors'] = null;
    }

    public function check(array $folders): array
    {
        foreach ($folders as $folder => $permission) {
            if (intval($this->getPermission($folder)) < intval($permission)) {
                $this->addFileAndSetErrors($folder, $permission, false);
            } else {
                $this->addFile($folder, $permission, true);
            }
        }

        return $this->results;
    }

    private function getPermission(string $folder): string
    {
        $folderPath = base_path($folder);
        $permissions = fileperms($folderPath);
        $permissionsAsString = sprintf('%o', $permissions);

        return substr($permissionsAsString, -3);
    }

    private function addFile(string $folder, string $permission, bool $isSet): void
    {
        $this->results['permissions'][] = [
            'folder' => $folder,
            'permission' => $permission,
            'isSet' => $isSet,
        ];
    }

    private function addFileAndSetErrors(string $folder, string $permission, bool $isSet): void
    {
        $this->addFile($folder, $permission, $isSet);
        $this->results['errors'] = true;
    }
}
