<?php

namespace Bongo\Install\Http\Controllers;

use Bongo\Install\Helpers\PermissionsChecker;
use Illuminate\Routing\Controller;

class PermissionsController extends Controller
{
    protected PermissionsChecker $permissions;

    public function __construct(PermissionsChecker $checker)
    {
        $this->permissions = $checker;
    }

    public function index()
    {
        $permissions = $this->permissions->check(
            config('install.permissions')
        );

        session()->put('step', 3);

        return view('install::permissions', compact('permissions'));
    }
}
