<?php

namespace Bongo\Install\Http\Controllers;

use Bongo\Install\Helpers\RequirementsChecker;
use Illuminate\Routing\Controller;

class RequirementsController extends Controller
{
    protected RequirementsChecker $requirements;

    public function __construct(RequirementsChecker $checker)
    {
        $this->requirements = $checker;
    }

    public function index()
    {
        $phpSupportInfo = $this->requirements->checkPhpVersion(
            config('install.core.minPhpVersion')
        );
        $requirements = $this->requirements->check(
            config('install.requirements')
        );

        session()->put('step', 2);

        return view('install::requirements', compact('requirements', 'phpSupportInfo'));
    }
}
