<?php

namespace Bongo\Install\Http\Controllers;

use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Artisan;

class WelcomeController extends Controller
{
    public function index()
    {
        // Publish the config files
        Artisan::call('vendor:publish', [
            '--provider' => 'Bongo\Framework\FrameworkServiceProvider',
            '--tag' => 'config',
            '--force' => true,
        ]);

        // Publish the asset files
        Artisan::call('vendor:publish', [
            '--provider' => 'Bongo\Asset\AssetServiceProvider',
            '--tag' => 'bongo:assets',
            '--force' => true,
        ]);

        // Set the initial session step
        session()->put('step', 1);

        return view('install::welcome');
    }
}
