<!DOCTYPE html>
<html itemscope itemtype="http://schema.org/Article" lang="{{ app()->getLocale() }}">

    <head>
        @php
            $metaTitle = preg_replace("/\?.*$/", '', request()->path());
            $metaTitle = ucwords(str_replace(['_', '-', '/'], ' ', $metaTitle));
            $pageClass = request()->segment(1) ? str()->singular(request()->segment(1)) . '-page' : '';
        @endphp

        <title>@yield('meta_title', $metaTitle)</title>
        @include('framework::backend.layouts.partials.favicon')

        @section('header_css')
            <link rel="stylesheet" href="https://rsms.me/inter/inter.css">
            <link rel="stylesheet" type="text/css" href="{{ mix('css/backend.css') }}"/>
        @show
        @yield('header_javascript')
    </head>

    <body class="relative antialiased font-sans bg-gray-100 text-gray-900 @yield('body_class', $pageClass)">

        <div class="lg:border-t lg:border-b lg:border-gray-200 mb-10 md:mb-20 lg:mb-24">
            @include('install::layouts.partials.steps')
        </div>

        <div class="mx-auto max-w-screen-md px-4 sm:px-6 lg:px-8 mb-6">
            <h2 class="text-center text-2xl leading-9 font-semibold uppercase text-gray-800">
                @yield('heading')
            </h2>
        </div>

        <div class="mx-auto max-w-screen-md px-4 sm:px-6 lg:px-8">
            @yield('content')
        </div>

        @include('blade::message')
    </body>
</html>
