@extends('install::layouts.app')

@section('meta_title', 'Server Requirements')
@section('heading', 'Server Requirements')

@section('content')
    <div class="bg-white shadow overflow-hidden sm:rounded-md">
        <ul>
            @foreach($requirements['requirements'] as $type => $requirement)
                <li class="{{ $loop->first ?: 'border-t border-gray-200'}}">
                    <div
                        class="block hover:bg-gray-50 focus:outline-none focus:bg-gray-50 transition duration-150 ease-in-out"
                    >
                        <div class="flex items-center px-4 py-4 sm:px-6">
                            <div class="min-w-0 flex-1 flex items-center">

                                <div class="min-w-0 flex-1 px-4 md:grid md:grid-cols-2 md:gap-4">

                                    <div class="flex items-center text-sm leading-5 font-medium">
                                        {{ strtoupper($type) }}&nbsp;-&nbsp;
                                        @if($type == 'php')
                                            <small class="text-gray-500">
                                                (version {{ $phpSupportInfo['minimum'] }} required)
                                            </small>
                                        @endif
                                    </div>

                                    <div class="flex items-center text-sm leading-5 text-gray-500">
                                        @if($type == 'php')
                                            @if($phpSupportInfo['supported'])
                                                <svg class="flex-shrink-0 mr-1.5 h-5 w-5 text-green-400"
                                                     xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                                     fill="currentColor"
                                                >
                                                    <path fill-rule="evenodd"
                                                          d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                          clip-rule="evenodd"
                                                    />
                                                </svg>
                                            @else
                                                <svg class="flex-shrink-0 mr-1.5 h-5 w-5 text-red-400"
                                                     fill="currentColor" viewBox="0 0 20 20"
                                                     xmlns="http://www.w3.org/2000/svg"
                                                >
                                                    <path fill-rule="evenodd"
                                                          d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z"
                                                          clip-rule="evenodd"
                                                    ></path>
                                                </svg>
                                            @endif
                                            {{ $phpSupportInfo['current'] }}
                                        @endif
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>
                </li>
                @foreach($requirements['requirements'][$type] as $extension => $enabled)
                    <li class="border-t border-gray-200">
                        <div
                            class="block hover:bg-gray-50 focus:outline-none focus:bg-gray-50 transition duration-150 ease-in-out"
                        >
                            <div class="flex items-center px-4 py-4 sm:px-6">
                                <div class="min-w-0 flex-1 flex items-center">

                                    <div class="min-w-0 flex-1 px-4 md:grid md:grid-cols-2 md:gap-4">
                                        <div class="flex items-center text-sm leading-5 font-medium">
                                            {{ strtoupper($extension) }}
                                        </div>
                                        <div class="flex items-center text-sm leading-5 text-gray-500">
                                            @if($enabled)
                                                <svg class="flex-shrink-0 mr-1.5 h-5 w-5 text-green-400"
                                                     xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                                                     fill="currentColor"
                                                >
                                                    <path fill-rule="evenodd"
                                                          d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                          clip-rule="evenodd"
                                                    />
                                                </svg>
                                            @else
                                                <svg class="flex-shrink-0 mr-1.5 h-5 w-5 text-red-400"
                                                     fill="currentColor" viewBox="0 0 20 20"
                                                     xmlns="http://www.w3.org/2000/svg"
                                                >
                                                    <path fill-rule="evenodd"
                                                          d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z"
                                                          clip-rule="evenodd"
                                                    ></path>
                                                </svg>
                                            @endif
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </li>

                @endforeach
            @endforeach
        </ul>
    </div>

    @if (!isset($requirements['errors']) && $phpSupportInfo['supported'] )
        <div class="actions mt-10 mb-10 text-center">
            <a href="{{ route('install.permissions') }}"
               class="inline-block py-3 px-4 border border-transparent text-sm font-medium rounded-sm text-white bg-primary-600 hover:bg-primary-500 focus:outline-none focus:border-primary-700 focus:shadow-outline-primary active:bg-primary-700 transition duration-150 ease-in-out"
            >
                Continue to Folder Permissions
            </a>
        </div>
    @endif
@endsection
