@extends('install::layouts.app')

@section('meta_title', 'Summary')
@section('heading', 'Summary')
@section('header_javascript')
    <script src="https://cdn.jsdelivr.net/gh/google/code-prettify@master/loader/run_prettify.js?skin=sunburst"></script>
@endsection

@section('content')

    @component('blade::card', ['cardClass' => 'mb-6'])
        <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
            <div class="sm:col-span-1">
                @static(['name' => 'Username', 'value' => $user->email])
            </div>
            <div class="sm:col-span-1">
                @static(['name' => 'Password', 'value' => $password])
            </div>
        </div>
    @endcomponent

    @component('blade::card', ['cardClass' => 'mb-6', 'class' => 'p-4'])
        @slot('header')
            .env File:
        @endslot
        <pre class="prettyprint m-0"><code class="text-xs">{{ $envFile }}</code></pre>
    @endcomponent

    @component('blade::card', ['cardClass' => 'mb-6', 'class' => 'p-4'])
        @slot('header')
            Console Output:
        @endslot
        <pre class="prettyprint m-0"><code class="text-xs">{{ $databaseOutput }}</code></pre>
    @endcomponent

    <div class="actions mt-10 mb-10 text-center">
        <form method="POST" action="{{ route('install.summary.store', $user) }}">
            {{ csrf_field() }}

            <div class="actions mt-10 mb-10 text-center">
                <button type="submit"
                        class="inline-block py-3 px-4 border border-transparent text-sm font-medium rounded-sm text-white bg-primary-600 hover:bg-primary-500 focus:outline-none focus:border-primary-700 focus:shadow-outline-primary active:bg-primary-700 transition duration-150 ease-in-out"
                >
                    Exit and Continue to Site
                </button>
            </div>
        </form>
    </div>
@endsection
