<?php

namespace Bongo\Install\Helpers;

use Exception;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\PhpExecutableFinder;
use Symfony\Component\Process\Process;

class ConsoleManager
{
    private string $composerBin;

    private string $phpBin;

    /**
     * @throws Exception
     */
    public function __construct()
    {
        $this->setPhpExecutable();
        $this->setComposerExecutable();
    }

    public function runCommand(string $command): string
    {
        $process = Process::fromShellCommandline($command, base_path());
        $process->run();

        if (! $process->isSuccessful()) {
            throw new ProcessFailedException($process);
        }

        return $process->getOutput();
    }

    public function runPhpCommand(string $command): string
    {
        $cmdLine = str_replace('\\', '/', "{$this->phpBin} {$command}");

        return $this->runCommand($cmdLine);
    }

    public function runComposerCommand(string $command): string
    {
        $cmdLine = str_replace('\\', '/', "{$this->phpBin} {$this->composerBin} {$command}");

        return $this->runCommand($cmdLine);
    }

    /**
     * @throws Exception
     */
    private function setPhpExecutable(): void
    {
        // Set the PHP binary executable
        $phpFinder = new PhpExecutableFinder();

        $this->phpBin = $phpFinder->find();
        if (! $this->phpBin) {
            throw new Exception("Could not find the PHP binary file to execute");
        }
    }

    /**
     * @throws Exception
     */
    private function setComposerExecutable(): void
    {
        // Set the composer binary executable
        $this->composerBin = base_path('vendor/bin/composer.phar');

        if (! file_exists(base_path('vendor/bin/composer.phar'))) {
            throw new Exception("Could not find the Composer binary file to execute");
        }
    }
}
