<?php

namespace Bongo\Install\Helpers;

class RequirementsChecker
{
    private string $minPhpVersion = '8.2.0';

    public function check(array $requirements): array
    {
        $results = [];

        // Check the php requirements
        if (! empty($requirements['php'])) {
            foreach ($requirements['php'] as $requirement) {
                $results['requirements']['php'][$requirement] = true;
                if (! extension_loaded($requirement)) {
                    $results['requirements']['php'][$requirement] = false;
                    $results['errors'] = true;
                }
            }
        }

        // Check the apache requirements
        if (! empty($requirements['apache']) && function_exists('apache_get_modules')) {
            foreach ($requirements['apache'] as $requirement) {
                $results['requirements']['apache'][$requirement] = true;
                if (! in_array($requirement, apache_get_modules())) {
                    $results['requirements']['apache'][$requirement] = false;
                    $results['errors'] = true;
                }
            }
        }

        return $results;
    }

    public function checkPhpVersion(string $minPhpVersion = null): array
    {
        $minVersionPhp = $minPhpVersion;
        $currentPhpVersion = $this->getPhpVersionInfo();
        $supported = false;

        if ($minPhpVersion == null) {
            $minVersionPhp = $this->getMinPhpVersion();
        }

        if (version_compare($currentPhpVersion['version'], $minVersionPhp) >= 0) {
            $supported = true;
        }

        return [
            'full' => $currentPhpVersion['full'],
            'current' => $currentPhpVersion['version'],
            'minimum' => $minVersionPhp,
            'supported' => $supported,
        ];
    }

    private static function getPhpVersionInfo(): array
    {
        $currentVersionFull = PHP_VERSION;
        preg_match("#^\d+(\.\d+)*#", $currentVersionFull, $filtered);
        $currentVersion = $filtered[0];

        return [
            'full' => $currentVersionFull,
            'version' => $currentVersion,
        ];
    }

    protected function getMinPhpVersion(): string
    {
        return $this->minPhpVersion;
    }
}
