<?php

namespace Bongo\Install\Http\Controllers;

use Bongo\Install\Helpers\EnvironmentManager;
use Bongo\Install\Helpers\RobotsManager;
use Bongo\Install\Http\Requests\StoreEnvironmentRequest;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\DB;

class EnvironmentController extends Controller
{
    protected EnvironmentManager $environmentManager;

    protected RobotsManager $robotsManager;

    public function __construct(
        RobotsManager $robotsManager,
        EnvironmentManager $environmentManager
    ) {
        $this->environmentManager = $environmentManager;
        $this->robotsManager = $robotsManager;
    }

    public function index()
    {
        $env = $this->environmentManager->getAsArray();

        session()->put('step', 4);

        return view('install::environment', compact('env'));
    }

    public function store(StoreEnvironmentRequest $request, Redirector $redirect)
    {
        if (! $this->checkDatabaseConnection($request)) {
            return $redirect
                ->route('install.environment')
                ->withInput()
                ->withErrors([
                    'database_connection' => trans('install::frontend.environment.wizard.form.db_connection_failed'),
                ]);
        }

        // Set the .env & robots.txt files
        $this->robotsManager->set($request);
        $results = $this->environmentManager->set($request);

        return $redirect
            ->route('install.summary')
            ->with(['results' => $results]);
    }

    private function checkDatabaseConnection(Request $request)
    {
        config()->set('database.connections.mysql.host', $request->input('database_host'));
        config()->set('database.connections.mysql.database', $request->input('database_name'));
        config()->set('database.connections.mysql.username', $request->input('database_username'));
        config()->set('database.connections.mysql.password', $request->input('database_password'));

        // Disconnect from the current database and clear the cache
        DB::purge('mysql');

        try {
            // Now try to reconnect using the new credentials
            DB::connection()->getPdo();

            return true;

        } catch (Exception $e) {
            return false;
        }
    }
}
