<?php

namespace Bongo\Install\Http\Controllers;

use Bongo\Install\Helpers\DatabaseManager;
use Bongo\Install\Helpers\EnvironmentManager;
use Bongo\Setting\SettingServiceProvider;
use Bongo\User\Models\User;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;

class SummaryController extends Controller
{
    private DatabaseManager $databaseManager;

    private EnvironmentManager $environmentManager;

    public function __construct(
        DatabaseManager $databaseManager,
        EnvironmentManager $environmentManager
    ) {
        $this->databaseManager = $databaseManager;
        $this->environmentManager = $environmentManager;
    }

    public function index()
    {
        app()->register(SettingServiceProvider::class);

        // Make sure the database is empty before we do anything
        $this->databaseManager->reset();

        // Run the migrations and seed the database
        $databaseOutput = $this->databaseManager->migrateAndSeed();

        // Create the default developer account
        [$user, $password] = $this->databaseManager->createDeveloperAccount();

        // Get the env file data
        $envFile = $this->environmentManager->get();

        // Update the session step
        session()->put('step', 5);

        return view('install::summary', compact('user', 'password', 'envFile', 'databaseOutput'));
    }

    public function store(User $user)
    {
        // Mark the installation as complete
        $this->environmentManager->prepend('INSTALL_COMPLETE=true');

        // Remove the steps from the session
        session()->forget('step');
        session()->invalidate();
        session()->regenerate();

        // Clear the views & cache
        Artisan::call('cache:clear');
        Artisan::call('view:clear');

        // Log the developer in
        Auth::loginUsingId($user->id);

        // Redirect the developer to the admin/settings screen
        return redirect()
            ->to(config('settings.backend_prefix').'/settings')
            ->success('Install complete');
    }
}
