<?php

namespace Bongo\Install;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Install\Http\ViewComposers\StepComposer;

class InstallServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'install';

    protected array $composers = [
        StepComposer::class => [
            'install::layouts.partials.steps',
        ],
    ];

    public function boot(): void
    {
        parent::boot();

        // Once the app is booted include the helper functions
        $this->app->booted(function () {
            include __DIR__.'/helpers.php';
        });
    }
}
