<?php

use Bongo\Install\Http\Controllers\EnvironmentController;
use Bongo\Install\Http\Controllers\PermissionsController;
use Bongo\Install\Http\Controllers\RequirementsController;
use Bongo\Install\Http\Controllers\SummaryController;
use Bongo\Install\Http\Controllers\WelcomeController;
use Illuminate\Support\Facades\Route;

Route::as('install.')
    ->prefix('install')
    ->group(function () {

        Route::get('/', [WelcomeController::class, 'index'])
            ->name('welcome');

        Route::get('requirements', [RequirementsController::class, 'index'])
            ->name('requirements');

        Route::get('permissions', [PermissionsController::class, 'index'])
            ->name('permissions');

        Route::get('environment', [EnvironmentController::class, 'index'])
            ->name('environment');

        Route::post('environment/store', [EnvironmentController::class, 'store'])
            ->name('environment.store');

        Route::get('summary', [SummaryController::class, 'index'])
            ->name('summary');

        Route::post('summary/store/{user}', [SummaryController::class, 'store'])
            ->name('summary.store');
    });

// Redirect any other request to the installation screen
Route::get('{any}', fn () => redirect('install'))
    ->where('any', '.*');
