# Changelog

All notable changes to `bongo/menu` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.8] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` (529 lines) - Cursor IDE guidance with project structure, patterns, and conventions
  - `ARCHITECTURE.md` (1,128 lines) - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` (573 lines) - GitHub Copilot code templates and patterns
- **Enhanced CLAUDE.md**: Expanded Claude Code guidance (198 new lines)
- Updated `composer.json` dependencies

### Improved
- **Multi-Level Dropdown Support**: Enhanced frontend main menu to handle multi-level dropdowns
  - Updated `src/Views/frontend/partials/main_menu.blade.php` with improved structure (44 deletions, minor additions)
  - Added `src/Views/frontend/partials/main_menu_dropdown_item.blade.php` (42 lines) - Dropdown item rendering
  - Added `src/Views/frontend/partials/main_menu_item.blade.php` (45 lines) - Menu item rendering
  - Better hierarchical menu navigation
  - Improved dropdown behavior and styling

### Enhanced
- **Backend Show Screen**: Updated show screen structure and styling
  - Updated `src/Http/Controllers/Backend/MenuController.php` (9 line cleanup)
  - Added `src/Views/backend/partials/menu_item.blade.php` (17 lines) - Menu item display component
  - Added `src/Views/backend/partials/sub_menu_item.blade.php` (51 lines) - Sub-menu item display component
  - Updated `src/Views/backend/show.blade.php` with improved structure (59 deletions, partial rewrite)
  - Consistent styling with edit screen
  - Better visual hierarchy

### Fixed
- **Cascade Delete**: Updated delete menu item function to cascade delete child items
  - Ensures child menu items are properly removed when parent is deleted
  - Prevents orphaned menu items
  - Maintains database integrity

### Changed
- **API-Based Methods**: Updated controllers to use new API-based methods
  - Better separation of concerns
  - RESTful API compliance
  - Improved code organization

- **Resource Validation**: Fixed resource validation errors
  - Better error handling
  - Improved validation messages

## [3.0.0] - 2026-01-07

### Major Release - v3.0

This major version represents a complete rewrite with JSON:API standard compliance, comprehensive test coverage, and modern development tooling.

### Architecture Changes

#### JSON:API Standard Implementation
- **JSON:API Compliance**: Updated package to use JSON:API standard
  - RESTful API design
  - Standardized response formats
  - Better API documentation
  - Consistent error handling
  - Pagination support
  - Resource relationships

#### Service Provider Modernization
- **Root Level Files**: Updated to current standards
  - Modern composer.json configuration
  - Updated README.md structure
  - Enhanced package metadata
  - Better dependency management

#### Configuration
- **Config Directory**: Added missing config directory structure
  - Proper config file organization
  - Environment-based configuration
  - Better config caching support

### Testing Infrastructure

#### Unit Test Suite
- **Basic Unit Tests**: Added comprehensive unit test coverage
  - Menu model tests
  - MenuItem model tests
  - MenuItemService tests
  - Relationship testing
  - Validation testing
  - Cache management tests

#### Test Factories
- **Default Factories**: Added factories for testing purposes
  - MenuFactory for creating test menus
  - MenuItemFactory for creating test menu items
  - Faker integration
  - Customizable attributes
  - Relationship support

#### Test Case Updates
- **Fixed TestCase**: Resolved test case configuration errors
  - Proper Orchestra Testbench setup
  - Database migration loading
  - Service provider registration
  - Testing environment configuration

### Code Quality

#### PHPStan Integration
- **Static Analysis**: Fixed missing class definitions in PHPStan
  - Level 1 static analysis
  - Proper type declarations
  - Better code quality assurance

#### Code Formatting
- **Laravel Pint**: Ran pint to cleanup codebase
  - Laravel code style preset
  - Consistent formatting
  - Automated code fixes
  - 323 lines affected

### Real-Time Operations
- **Simplified Code Structure**: Started simplifying code with real-time operations
  - Real-time create, update, and delete
  - Better user experience
  - Reduced page reloads
  - AJAX-based operations

### Documentation
- **Default Context Markdown**: Added comprehensive markdown documentation
  - CLAUDE.md for AI assistance
  - Development guidelines
  - Architecture overview
  - API documentation

## [2.0.18] - 2025-11-24

### Added
- **DT-551**: Menu Builder Changes
  - Enhanced menu builder functionality
  - Improved user interface
  - Better menu management tools

- **DT-490**: Bootstrap Js 5.2.3 Upgrade
  - Upgraded to Bootstrap 5.2.3
  - Better responsive design
  - Modern UI components
  - Improved accessibility

- **DT-446**: Menu Widget
  - New menu widget functionality
  - Widget-based menu display
  - Configurable widget options
  - Better integration with page builder

### Features
- **DT-458**: Menu Document Link
  - Added support for linking to documents
  - Document asset integration
  - File download links in menus
  - Uses `asset()` helper for document URLs
  - Special handling for document entity type

### Framework Updates
- **Laravel 10 & PHP 8.2 Upgrade**: Complete framework upgrade
  - Updated `composer.json` for Laravel 10 compatibility
  - Updated codebase for PHP 8.2 compatibility
  - Modernized type declarations and nullable types
  - Updated Pint and StyleCI configurations

### Improvements
- **Install Script**: Updated to check for tables before creating them
  - Prevents migration errors
  - Better upgrade path
  - Safer installations

- **DT-275**: Menu Confirmation
  - Added confirmation dialogs for destructive actions
  - Better user experience
  - Prevents accidental deletions

### Configuration
- Added code settings to repository
  - EditorConfig for consistent formatting
  - StyleCI configuration
  - IDE helper files

## [1.0.0] - Initial Release

### Features
- Menu CRUD operations
- Hierarchical menu structure with unlimited nesting
- Menu item types:
  - Internal links (pages, posts, projects, categories)
  - External links
- Menu item attributes:
  - Name, URL, CSS class
  - Target (self/blank)
  - Sort ordering
- Status management (pending/active/inactive)
- Soft deletes
- UUID-based identification
- Key-based programmatic access
- Backend admin interface
  - Create, edit, delete menus
  - Nested menu item management
  - Drag-and-drop reordering
  - DataTables integration
- Frontend templates
  - Main menu
  - Top menu
  - Footer menu
  - Footer menu 2
  - Bottom menu
  - Custom menu partials
- View composers for automatic menu loading
- Event handling (MenuEventHandler)
- Cache management
- Multi-level dropdown support
- Polymorphic entity relationships
- Entity type discovery based on enabled packages
- Route generation for internal links
- Asset links for documents

---

**Package**: `bongo/menu`
**Description**: Add the ability to create frontend menus from within the admin
**Repository**: https://bitbucket.org/designtec/menu
**Private Composer Repository**: https://designtecpackages.co.uk
