<?php

declare(strict_types=1);

namespace Bongo\Menu\Database\Factories;

use Bongo\Menu\Models\MenuItem;
use Illuminate\Database\Eloquent\Factories\Factory;

class MenuItemFactory extends Factory
{
    protected $model = MenuItem::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->words(3, true),
            'type' => MenuItem::INTERNAL,
            'target' => MenuItem::SELF,
        ];
    }
}
