<?php

declare(strict_types=1);

namespace Bongo\Menu\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Menu\Http\Requests\Backend\StoreMenuRequest;
use Bongo\Menu\Http\Requests\Backend\UpdateMenuRequest;
use Bongo\Menu\Models\Menu;
use Bongo\Menu\Models\MenuItem;
use Illuminate\Http\RedirectResponse;

class MenuController extends AbstractController
{
    protected Menu $menu;

    protected MenuItem $menuItem;

    public function __construct(Menu $menu, MenuItem $menuItem)
    {
        $this->menu = $menu;
        $this->menuItem = $menuItem;
    }

    public function index()
    {
        return view('menu::backend.index');
    }

    public function create()
    {
        $menu = $this->menu;

        return view('menu::backend.create', compact('menu'));
    }

    public function store(StoreMenuRequest $request)
    {
        $validated = $request->validated();
        $menu = $this->menu->create($validated);

        return redirect()
            ->route('backend.menu.show', $menu->id)
            ->success(trans('menu::backend.store_success'));
    }

    public function show(Menu $menu)
    {
        $menu->load('items.nestedChildren');

        return view('menu::backend.show', compact('menu'));
    }

    public function edit(Menu $menu)
    {
        return view('menu::backend.edit', compact('menu'));
    }

    public function update(UpdateMenuRequest $request, Menu $menu): RedirectResponse
    {
        $validated = $request->validated();
        $menu->update($validated);

        return redirect()
            ->route('backend.menu.show', $menu->id)
            ->success(trans('menu::backend.update_success'));
    }

    public function destroy(Menu $menu)
    {
        if ($menu->delete()) {
            $redirect = back();

            // If the menu was deleted from their detail view,
            // we'll redirect back to the menu list view.
            if (route('backend.menu.show', $menu) == $redirect->getTargetUrl()) {
                $redirect = redirect()->route('backend.menu.index');
            }

            return $redirect->success(trans('menu::backend.delete_success'));
        }

        return back()->error(trans('menu::backend.delete_failed'));
    }
}
