<?php

declare(strict_types=1);

namespace Bongo\Menu\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class StoreMenu extends FormRequest
{
    public function rules(): array
    {
        return [
            // Standard API
            'data' => 'required|array',
            'data.type' => 'required|in:menu',
            'data.attributes' => 'required|array',

            // Individual fields
            'data.attributes.name' => 'sometimes|required|string|max:255',

            // Audit fields
            'data.attributes.created_at' => 'sometimes|required|string|date_format:Y-m-d H:i:s',
            'data.attributes.created_by' => 'sometimes|required|integer|max_digits:4',

            'data.attributes.updated_at' => 'sometimes|required|string|date_format:Y-m-d H:i:s',
            'data.attributes.updated_by' => 'sometimes|required|integer|max_digits:4',

            'data.attributes.deleted_at' => 'sometimes|nullable|string|date_format:Y-m-d H:i:s',
            'data.attributes.deleted_by' => 'sometimes|required|integer|max_digits:4',
        ];
    }
}
