<?php

declare(strict_types=1);

namespace Bongo\Menu\Http\Requests\Backend;

use Illuminate\Foundation\Http\FormRequest;

class UpdateMenuRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'name' => 'required',
            'status' => 'required|in:pending,active,inactive',
        ];
    }

    public function messages(): array
    {
        return [
            'items.*.name.required' => 'One of the menu items is missing the name field',
        ];
    }
}
