<?php

declare(strict_types=1);

namespace Bongo\Menu\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class MenuItemResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => (string) $this->getRouteKey(),
            'type' => 'menu_item',
            'attributes' => [

                // Individual Fields
                'menu_id' => $this->menu_id,
                'parent_id' => $this->parent_id,
                'uuid' => $this->uuid,
                'name' => $this->name,
                'url' => $this->url,

                'entity_type' => $this->entity_type,
                'entity_id' => $this->entity_id,

                'class' => $this->class,
                'image' => $this->image,
                'type' => $this->type,
                'target' => $this->target,
                'sort_order' => $this->sort_order,

                // Audit fields
                'created_at' => $this->created_at?->format('Y-m-d H:i:s'),
                'created_by' => $this->created_by,

                'updated_at' => $this->updated_at?->format('Y-m-d H:i:s'),
                'updated_by' => $this->updated_by,

                'deleted_at' => $this->deleted_at?->format('Y-m-d H:i:s'),
                'deleted_by' => $this->deleted_by,
            ],
            'relationships' => [
                'menu' => new MenuResource($this->whenLoaded('menu')),
                'parent' => new MenuItemResource($this->whenLoaded('parent')),
                'nested_children' => MenuItemResource::collection($this->whenLoaded('nestedChildren')),
            ],
        ];
    }
}
