<?php

declare(strict_types=1);

namespace Bongo\Menu\Http\Resources;

use Bongo\Menu\Models\Menu;
use Illuminate\Http\Resources\Json\JsonResource;

class MenuResource extends JsonResource
{
    public function toArray($request): array
    {
        /** @var Menu $this */
        return [
            'id' => (string) $this->getRouteKey(),
            'type' => 'menu',
            'attributes' => [

                // Individual Fields
                'uuid' => $this->uuid,
                'name' => $this->name,
                'key' => $this->key,
                'status' => $this->status,

                // Audit fields
                'created_at' => $this->created_at?->format('Y-m-d H:i:s'),
                'created_by' => $this->created_by,

                'updated_at' => $this->updated_at?->format('Y-m-d H:i:s'),
                'updated_by' => $this->updated_by,

                'deleted_at' => $this->deleted_at?->format('Y-m-d H:i:s'),
                'deleted_by' => $this->deleted_by,
            ],
            'relationships' => [
                'items' => MenuItemResource::collection($this->whenLoaded('items')),
            ],

        ];
    }
}
