<?php

declare(strict_types=1);

namespace Bongo\Menu\Http\ViewComposers;

use Bongo\Menu\Models\Menu;
use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

class MenuComposer
{
    public function compose(View $view): void
    {
        $viewData = $view->getData();

        if (isset($viewData['key']) && ! empty($viewData['key'])) {

            $menu = Cache::remember($viewData['key'], config('settings.cache_default'),
                function () use ($viewData) {
                    return Menu::where('key', $viewData['key'])
                        ->where('status', Menu::ACTIVE)
                        ->with('items')
                        ->first();
                }
            );

            $view->with(compact('menu'));
        }
    }
}
