<?php

declare(strict_types=1);

use Bongo\Menu\Http\Controllers\Backend\MenuController;
use Bongo\Menu\Http\Controllers\Backend\MenuDatatableController;
use Illuminate\Support\Facades\Route;

Route::as('menu.')
    ->prefix('menu')
    ->group(function () {

        Route::get('/', [MenuController::class, 'index'])
            ->name('index');

        Route::get('create', [MenuController::class, 'create'])
            ->name('create');

        Route::post('store', [MenuController::class, 'store'])
            ->name('store');

        Route::get('datatable', [MenuDatatableController::class, 'index'])
            ->name('datatable');

        // Menu/{menu}/
        Route::prefix('{menu}')
            ->group(function () {
                Route::get('/', [MenuController::class, 'show'])
                    ->name('show');

                Route::get('edit', [MenuController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [MenuController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [MenuController::class, 'destroy'])
                    ->name('destroy');
            });
    });
