<div
    class="sub-menu-item mx-3 mt-2 mb-2"
    data-id="{{ $subMenuItem->id }}"
    data-name="{{ $subMenuItem->name }}"
    data-type="{{ $subMenuItem->type }}"
    data-depth="{{ $depth }}"
    data-index="{{ $index }}"
    data-sort-order="{{ $subMenuItem->sort_order }}"
>
    <div class="px-3 py-1 border border-l-4 border-gray-300 bg-gray-300 bg-gray-200">
        <div class="grid grid-cols-2 md:grid-cols-1 lg:grid-cols-2 gap-2 items-center">
            <div class="col-span-1">
                <span
                    @class([
                        'mr-1 px-3 py-0.5',
                        'inline-flex items-center',
                        'rounded-full text-xs font-medium leading-5',
                        'bg-gray-100 text-gray-800',
                    ])
                >
                    {{ $subMenuItem->sort_order }}
                </span>
                <span class="text-sm">
                    {{ $subMenuItem->name }}
                </span>
                <span
                    @class([
                        'ml-1 px-2 py-0.5',
                        'inline-flex items-center',
                        'rounded text-xs font-medium leading-4',
                        'bg-indigo-100 text-indigo-800',
                    ])
                >
                    {{ $subMenuItem->type }}
                </span>
            </div>
        </div>
    </div>

    @if($subMenuItem->hasNestedChildren())
        <div class="sub-menu">
            @foreach($subMenuItem->nestedChildren as $childItem)
                @include('menu::backend.partials.sub_menu_item', [
                    'subMenuItem' => $childItem,
                    'index' => $loop->index,
                    'depth' => $depth + 1,
                ])
            @endforeach
        </div>
    @endif
</div>
