<?php

use Bongo\Document\Models\Document;
use Bongo\Page\Models\Page;
use Bongo\Post\Models\Post;
use Bongo\Post\Models\PostCategory;
use Bongo\Project\Models\Project;
use Bongo\Project\Models\ProjectCategory;

return [
    'entities' => [
        'document' => Document::class,
        'page' => Page::class,
        'post' => Post::class,
        'post_category' => PostCategory::class,
        'project' => Project::class,
        'project_category' => ProjectCategory::class,
    ],
    'routes' => [
        'page' => 'frontend.page.show',
        'post' => 'frontend.post.show',
        'post_category' => 'frontend.post_category.show',
        'project' => 'frontend.project.show',
        'project_category' => 'frontend.project_category.show',
    ],
];
