<?php

namespace Bongo\Menu\Events;

use Bongo\Framework\Events\AbstractEventHandler;
use Bongo\Menu\Models\Menu;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class MenuEventHandler extends AbstractEventHandler
{
    protected string $model = Menu::class;

    public function onCreating($model): void
    {
        parent::onCreating($model);

        if (Schema::hasColumn($model->getTable(), 'key')) {
            $model->key = Str::slug($model->name, '_');
        }
    }

    public function onSave($model): void
    {
        parent::onSave($model);

        $model->clearCache();
    }
}
