<?php

namespace Bongo\Menu\Http\Controllers\Api;

use Bongo\Framework\Http\Controllers\AbstractApiController;
use Bongo\Menu\Models\MenuItem;

class MenuItemController extends AbstractApiController
{
    public function index()
    {
        $itemId = request('item_id');
        $entityType = request('entity_type');

        $query = MenuItem::query()->orderBy('name');

        if (! empty($itemId)) {
            $query->where('id', '<>', $itemId);
        }

        if (! empty($entityType)) {
            $query->where('entity_type', $entityType);
        }

        return response()->json([
            'data' => $query->get(),
        ]);
    }
}
