<?php

namespace Bongo\Menu\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateMenuRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'name' => 'required',
            'items.*.name' => 'sometimes|required',
        ];
    }

    public function messages(): array
    {
        return [
            'items.*.name.required' => 'One of the menu items is missing the name field',
        ];
    }
}
