<?php

namespace Bongo\Menu;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Menu\Events\MenuEventHandler;
use Bongo\Menu\Http\ViewComposers\MenuComposer;
use Bongo\Menu\Services\MenuEntityType;
use Illuminate\Foundation\AliasLoader;

class MenuServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'menu';

    protected array $composers = [
        MenuComposer::class => [
            'menu::frontend.partials.menu',
            'menu::frontend.partials.top_menu',
            'menu::frontend.partials.main_menu',
            'menu::frontend.partials.footer_menu',
            'menu::frontend.partials.footer_menu_2',
            'menu::frontend.partials.bottom_menu',
        ],
    ];

    protected array $subscribers = [
        MenuEventHandler::class,
    ];

    public function boot(): void
    {
        parent::boot();
        AliasLoader::getInstance()->alias('MenuEntityType', MenuEntityType::class);
    }
}
