<?php

use Bongo\Menu\Models\MenuItem;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMenuItemsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('menu_items')) {
            Schema::create('menu_items', function (Blueprint $table) {

                // Primary
                $table->increments('id');
                $table->uuid('uuid')->index();

                // Foreign keys
                $table->unsignedInteger('menu_id')->index();
                $table->foreign('menu_id')->references('id')->on('menus')->onUpdate('cascade')->onDelete('cascade');
                $table->unsignedInteger('parent_id')->nullable()->index();

                // Fields
                $table->string('name');
                $table->string('url')->nullable();
                $table->string('entity_type')->nullable();
                $table->string('entity_id')->nullable();

                $table->string('class')->nullable();
                $table->enum('type', [MenuItem::INTERNAL, MenuItem::EXTERNAL])->default(MenuItem::INTERNAL);
                $table->enum('target', [MenuItem::SELF, MenuItem::BLANK])->default(MenuItem::SELF);
                $table->unsignedInteger('sort_order')->nullable()->index();

                // Audit
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->unsignedInteger('updated_by')->nullable()->index();

                // Timestamps
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('menu_items');
    }
}
