<?php

namespace Bongo\Menu\Services;

use Illuminate\Support\Facades\Log;
use Symfony\Component\Routing\Exception\RouteNotFoundException;

class MenuItemService
{
    public function routeLink($routeName, $menuItem): string
    {
        try {
            // Try and find the entity class from the config
            if ($entity = $menuItem->getEntity()) {
                return ! empty($entity->slug) ? route($routeName, $entity->slug) : '#';
            }

            return route($routeName, $menuItem->entity_id);

        } catch (RouteNotFoundException $e) {
            Log::info($e->getMessage());

            return '#';
        }
    }

    public function groupChildrenAsArray($menuItem): array
    {
        $children['groups'] = 1;
        $hasGroups = false;

        foreach ($menuItem->children as $key => $childItem) {
            $group = $childItem->group->name ?? $key;
            $hasGroups = $group !== $key;

            $children['links'][$group][] = $childItem;
        }

        if ($hasGroups) {
            $children['groups'] = count($children['links']);
        }

        return $children;
    }
}
