@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $menu->name }}
        @slot('actions')
            @deleteButton(['name' => trans('menu::backend.delete'), 'url' => route('backend.menu.destroy', $menu->id)])
            @backButton(['name' => trans('menu::backend.index'), 'url' => route('backend.menu.index')])
            @editButton(['name' => trans('menu::backend.edit'), 'url' => route('backend.menu.edit', $menu->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">
            <div class="md:col-span-1">
                @component('blade::card')
                    @static(['name' => 'Name', 'value' => $menu->name])
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card')
                    @static(['name' => 'Status', 'value' => $menu->status])
                @endcomponent
            </div>
        </section>

        <section>
            @if ($menu->hasItems())
                @foreach($menu->items as $menuItem)
                    <div class="mb-2 bg-white overflow-hidden shadow">
                        <div class="px-4 py-3">
                            <div class="grid grid-cols-2 md:grid-cols-1 lg:grid-cols-2 gap-2 items-center">
                                <div class="col-span-1">
                                    <span
                                        class="mr-1 inline-flex items-center px-3 py-0.5 rounded-full text-sm font-medium leading-5 bg-gray-100 text-gray-800"
                                    >
                                        {{ $menuItem->sort_order }}
                                    </span>
                                    <span class="text-sm">
                                        {{ $menuItem->name }}
                                    </span>
                                    <span
                                        class="ml-1 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-indigo-100 text-indigo-800"
                                    >
                                        {{ $menuItem->type }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    @if($menuItem->hasChildren())
                        @foreach($menuItem->children as $childItem)
                            <div class="mx-6 my-2 bg-white overflow-hidden shadow">
                                <div class="px-3 py-1">
                                    <div class="grid grid-cols-2 md:grid-cols-1 lg:grid-cols-2 gap-2 items-center">
                                        <div class="col-span-1">
                                            <span
                                                class="mr-1 inline-flex items-center px-3 py-0.5 rounded-full text-xs font-medium leading-5 bg-gray-100 text-gray-800"
                                            >
                                                {{ $childItem->sort_order }}
                                            </span>
                                            <span class="text-xs">
                                                {{ $childItem->name }}
                                            </span>
                                            <span
                                                class="ml-1 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-indigo-100 text-indigo-800"
                                            >
                                                {{ $childItem->type }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                @endforeach
            @else
                @component('blade::card')
                    <div class="message text-center">
                        <div class="message-text font-semibold">
                            No Menu Items Found
                        </div>
                    </div>
                @endcomponent
            @endif
        </section>
    @endcomponent
@stop
