@php
    $groupBy = 5;
@endphp

@if (isset($menu) && $menu->hasItems())
    <div class="row">

        @foreach($menu->items->chunk($groupBy) as $chunk)
            <div class="col-{{ $menu->items->count() > $groupBy ? 6 : 12 }}">

                @foreach($chunk as $menuItem)
                    <p class="mb-1">
                        <a href="{{ $menuItem->getLink() }}"
                           title="Link to {{ $menuItem->name }}"
                           aria-label="Link to {{ $menuItem->name }}"
                           target="{{ $menuItem->target }}"
                        >
                            {{ $menuItem->name }}
                        </a>
                    </p>
                @endforeach

            </div>
        @endforeach

    </div>
@endif
