<?php

declare(strict_types=1);

namespace Bongo\Menu\Database\Factories;

use Bongo\Menu\Models\Menu;
use Illuminate\Database\Eloquent\Factories\Factory;

class MenuFactory extends Factory
{
    protected $model = Menu::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->words(3, true),
            'status' => Menu::ACTIVE,
        ];
    }

    public function pending(): Factory
    {
        return $this->state(fn () => [
            'status' => Menu::PENDING,
        ]);
    }

    public function active(): Factory
    {
        return $this->state(fn () => [
            'status' => Menu::ACTIVE,
        ]);
    }

    public function inactive(): Factory
    {
        return $this->state(fn () => [
            'status' => Menu::INACTIVE,
        ]);
    }
}
