<?php

declare(strict_types=1);

namespace Bongo\Menu\Http\Controllers\Api;

use Bongo\Framework\Http\Controllers\AbstractApiController;
use Bongo\Menu\Http\Requests\Api\StoreMenu;
use Bongo\Menu\Http\Requests\Api\UpdateMenu;
use Bongo\Menu\Http\Resources\MenuCollection;
use Bongo\Menu\Http\Resources\MenuResource;
use Bongo\Menu\Models\Menu;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Response;

class MenuController extends AbstractApiController
{
    public function index()
    {
        $menus = Menu::class::query()
            ->with('items.nestedChildren')
            ->paginate();

        return new MenuCollection($menus);
    }

    public function store(StoreMenu $request): JsonResponse
    {
        $validated = $request->validated('data.attributes');

        // Create the menu
        $menu = new Menu();
        $menu->fill($validated);
        $menu->save();

        return (new MenuResource($menu))
            ->response()
            ->header('Location', route('backend.menu.show', $menu));
    }

    public function show(Menu $menu): MenuResource
    {
        $menu->load('items.nestedChildren');

        return new MenuResource($menu);
    }

    public function update(UpdateMenu $request, Menu $menu): MenuResource
    {
        $validated = $request->validated('data.attributes');

        // Update the menu
        $menu->fill($validated);
        $menu->save();

        return new MenuResource($menu);
    }

    public function destroy(Menu $menu): Application|ResponseFactory|Response
    {
        $menu->delete();

        return response(null, 204);
    }
}
