<?php

declare(strict_types=1);

namespace Bongo\Menu\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class StoreMenuItem extends FormRequest
{
    public function rules(): array
    {
        return [
            // Standard API
            'data' => 'required|array',
            'data.type' => 'required|in:menu_item',
            'data.attributes' => 'required|array',

            // Individual fields
            'data.attributes.menu_id' => 'required|integer|exists:menus,id',
            'data.attributes.parent_id' => 'nullable|integer|exists:menu_items,id',
            'data.attributes.name' => 'sometimes|required|string|max:255',
            'data.attributes.url' => 'nullable|string|max:100',

            'data.attributes.entity_type' => 'nullable|string|max:100',
            'data.attributes.entity_id' => 'nullable|integer',

            'data.attributes.class' => 'nullable|string|max:255',
            'data.attributes.image' => 'nullable|string|max:255',
            'data.attributes.type' => 'nullable|string|max:255',
            'data.attributes.target' => 'nullable|string|max:255',
            'data.attributes.sort_order' => 'nullable|integer',

            // Audit fields
            'data.attributes.created_at' => 'sometimes|required|string|date_format:Y-m-d H:i:s',
            'data.attributes.created_by' => 'nullable|integer|max_digits:4',

            'data.attributes.updated_at' => 'sometimes|required|string|date_format:Y-m-d H:i:s',
            'data.attributes.updated_by' => 'nullable|integer|max_digits:4',
        ];
    }
}
