<?php

declare(strict_types=1);

use Bongo\Menu\Models\Menu;
use Bongo\Menu\Seeders\PackageSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

class CreateMenusTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('menus')) {
            Schema::create('menus', function (Blueprint $table) {

                // Primary
                $table->increments('id');
                $table->uuid('uuid')->index();

                // Fields
                $table->string('name');
                $table->string('key')->nullable()->index();
                $table->enum('status', [Menu::PENDING, Menu::ACTIVE, Menu::INACTIVE])->default(Menu::PENDING);

                // Audit
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->unsignedInteger('updated_by')->nullable()->index();
                $table->unsignedInteger('deleted_by')->nullable()->index();

                // Timestamps
                $table->timestamps();
                $table->softDeletes();
            });
        }

        // If the package table exists then seed the package
        if (Schema::hasTable('packages')) {
            Artisan::call('db:seed', ['--class' => PackageSeeder::class]);
        }
    }

    public function down()
    {
        Schema::dropIfExists('menus');
    }
}
