<?php

declare(strict_types=1);

use Bongo\Menu\Http\Controllers\Api\MenuController;
use Bongo\Menu\Http\Controllers\Api\MenuItemController;
use Illuminate\Support\Facades\Route;

Route::prefix('menus')
    ->as('menu.')
    ->group(function () {
        Route::get('/', [MenuController::class, 'index'])
            ->name('index');

        Route::post('/', [MenuController::class, 'store'])
            ->name('store');

        Route::get('{menu}', [MenuController::class, 'show'])
            ->name('show');

        Route::post('{menu}/update', [MenuController::class, 'update'])
            ->name('update');

        Route::post('{menu}/delete', [MenuController::class, 'destroy'])
            ->name('destroy');
    });

Route::prefix('menu-items')
    ->as('menu_item.')
    ->group(function () {

        Route::get('/', [MenuItemController::class, 'index'])
            ->name('index');

        Route::post('/', [MenuItemController::class, 'store'])
            ->name('store');

        Route::get('{menuItem}', [MenuItemController::class, 'show'])
            ->name('show');

        Route::post('{menuItem}/update', [MenuItemController::class, 'update'])
            ->name('update');

        Route::post('{menuItem}/delete', [MenuItemController::class, 'destroy'])
            ->name('destroy');
    });
