<?php

declare(strict_types=1);

namespace Bongo\Menu\Seeders;

use Bongo\Menu\Models\Menu;
use Illuminate\Database\Seeder;

class DataSeeder extends Seeder
{
    public function run()
    {
        $rows = [
            [
                'name' => 'Top Menu',
                'key' => 'top_menu',
                'status' => Menu::ACTIVE,
            ],
            [
                'name' => 'Main Menu',
                'key' => 'main_menu',
                'status' => Menu::ACTIVE,
            ],
            [
                'name' => 'Footer Menu',
                'key' => 'footer_menu',
                'status' => Menu::ACTIVE,
            ],
        ];

        foreach ($rows as $row) {
            Menu::firstOrCreate($row);
        }
    }
}
